﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IDesktopProcessStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class DesktopProcessDefaultStrategy : ICorrespondenceOS, IDesktopProcessStrategy
    {
        public DesktopProcessDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "ClearPageFileAtShutdown";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management");

            return new WFRegistry(@"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management", RegName,
                              registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class DesktopProcessController
    {
        public DesktopProcessController(DesktopProcess desktopProcess,
                                                         IDesktopProcessStrategy strategy)
        {
            DesktopProcess = desktopProcess;
            Strategy = strategy;
        }

        public DesktopProcess DesktopProcess { get; set; }
        public IDesktopProcessStrategy Strategy { get; set; }

        public void Read()
        {
            DesktopProcess.SetDesktopProcessState(Convert.ToBoolean(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(DesktopProcess.GetDesktopProcessState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
